var PerSettings = {
	sDefaults:{
		numberformat:[",","."],
		radordeg:"deg",
		color_memory:"blue",
		color_clear:"red",
		color_operations:"gray",
		color_numbers:"black",
		color_equals:"green",
		color_extra:"beige",
		backcolor:"#1F202A"
	},
	sCurrent:new Array(),
	Init:function(){
		if (this.oFile.FileExists(this.sPath)){
			var tmpFile = this.oFile.OpenTextFile(this.sPath, 1);
			var fullText = tmpFile.ReadAll();
			tmpFile.Close();
			var fullArr = fullText.split("\n");
			var tmpArr;
			for (var i in fullArr){
				tmpArr=fullArr[i].split("=");
				if (tmpArr.length==2){
					this.sCurrent[tmpArr[0]]=this.StrToObj(tmpArr[1]);
				}
			}
		}
		var loadedDefault=false;
		for (var i in this.sDefaults){
			if (this.sCurrent[i]===undefined){
				loadedDefault=true;
				this.sCurrent[i]=this.Copy(this.sDefaults[i]);
			}
		}
		if (loadedDefault){
			this.SaveCurrent();
		}
	},
	Get:function(strName){
		return this.Copy(this.sCurrent[strName]);
	},
	Set:function(strName,strValue,dontSave){
		this.sCurrent[strName]=this.Copy(strValue);
		if (!dontSave){
			this.SaveCurrent();
		}
	},
	GetDefaults:function(){
		return this.Copy(this.sDefaults);
	},
	GetAll:function(){
		return this.Copy(this.sCurrent);
	},
	SetAll:function(arr){
		this.sCurrent=this.Copy(arr);
		this.SaveCurrent();
	},
	Copy:function(srcArr){
		if (typeof srcArr == "object"){
			var ret=[];
			for (var i in srcArr){
				ret[i]=this.Copy(srcArr[i]);
			}
			return ret;
		}else{
			return srcArr;
		}
	},
	SaveCurrent:function(){
		var fullText="";
		for (var i in this.sCurrent){
			fullText+=i+"="+this.ObjToStr(this.sCurrent[i])+"\n";
		}
		var tmpFile = this.oFile.CreateTextFile(this.sPath, true);
		tmpFile.Write(fullText);
		tmpFile.Close();
	},
	ObjToStr:function(obj){
		if (typeof obj == "object"){
			var tmpStr="a";
			var hasCount=false;
			for (var i in obj){
				tmpStr+=i+":"+this.ObjToStr(obj[i])+",";
				hasCount=true;
			}
			if (hasCount){
				tmpStr=tmpStr.substr(0,tmpStr.length-1);
			}
			return escape(tmpStr);
		}else if((obj===true)||(obj===false)){
			if (obj){
				return "b1";
			}else{
				return "b0";
			}
		}else{
			return "s"+escape(obj);
		}
	},
	StrToObj:function(str){
		var tmpType=str.substr(0,1)
		if (str.length==1){
			var tmpStr="";
		}else{
			var tmpStr=unescape(str.substr(1));
		}
		if (tmpType=="s"){
			return tmpStr.replace("\r","");
		}else if (tmpType=="b"){
			if (tmpStr=="1"){
				return true;
			}else{
				return false;
			}
		}else{
			var newArr=[];
			if (tmpStr!=""){
				var tmpArr=tmpStr.split(",");
				var tmpArr2;
				for (var i in tmpArr){
					tmpArr2=tmpArr[i].split(":");
					newArr[unescape(tmpArr2[0])]=this.StrToObj(tmpArr2[1]);
				}
			}
			return newArr;
		}
	},
	oFile:new ActiveXObject("Scripting.FileSystemObject"),
	sPath:System.Gadget.path+"/PerSettings.ini"
}
PerSettings.Init();
